
# Merge OCI images into a single image for subsequent upload.
merge_oci_images() {
	source_config || return 0
	info "Merging OCI images"

	# define paths for aarch64 and amd64 container images to merge
	# /releng/15-aarch64-GENERIC-snap/R/ociimages/container-image-$type.txz
	# /releng/15-amd64-GENERIC-snap/R/ociimages/container-image-$type.txz
	aarch64_path="/${zfs_mount}/${heads}-aarch64-GENERIC-${type}/R/ociimages/container-image"
	amd64_path="/${zfs_mount}/${heads}-amd64-GENERIC-${type}/R/ociimages/container-image"

	# define destination for merged OCI images, probably should be a dataset
	test -d ${OCI_DESTDIR} || mkdir -p ${OCI_DESTDIR}

	# podmanic	FreeBSD-14.3-PRERELEASE-arm64-aarch64-container-image-$t.txz \
	#			FreeBSD-14.3-PRERELEASE-amd64-container-image-$t.txz \
	#			freebsd-$t-14.3-prerelease.oci
	for t in ${oci_images}; do
		aarch64="${aarch64_path}-${t}.txz"
		amd64="${amd64_path}-${t}.txz"
		oci="${OCI_DESTDIR}/freebsd-${t}-${heads}"
		podmanic $aarch64 $amd64 $oci >> ${logdir}/${_build}.log 2>&1
		sha256 ${oci}.oci > ${oci}.oci.sha256 >> ${logdir}/${_build}.log 2>&1
	done
	return 0
}

main() {
	releasesrc="main"
	export __BUILDCONFDIR="$(dirname $(realpath ${0}))"

	while getopts "bc:du" opt; do
		case ${opt} in
			b)
				DOBUILD=YES
				;;
			c)
				CONF=${OPTARG}
				[ -e ${CONF} ] && . $(realpath ${CONF})
				;;
			d)
				debug=1
				;;
			u)
				DOUPLOAD=YES
				;;
			\?)
				usage
				;;
		esac
	done
	shift $(($OPTIND - 1))
	[ -z ${CONF} ] && usage
	if [ "$DOBUILD" ]; then
		check_zfs_mounts
		use_zfs=1
		check_use_zfs
		runall prebuild_setup
		runall truncate_logs
		runall zfs_mount_src
		runall build_chroots
		runall install_chroots
		runall zfs_clone_chroots
		zfs_finish_bootstrap
		runall ${parallel}build_release
		wait
	fi
	if [ "$OCI_MERGE" ]; then
		merge_oci_images
		# TODO bug_colin_to_sign_them
	fi
	if [ "$DOUPLOAD" ]; then
		runall upload_mount_devfs
		runall upload_ec2_ami
		runall upload_gce_image
		runall upload_vagrant_image
		runall upload_azure_image
		runall upload_oracle_image
		wait
		runall upload_umount_devfs
	fi
	send_completed_email
}

main "$@"
