function oci-launch-arm64
set -l USERDATA (mktemp -t oci)
echo '#!/bin/sh -eux
set -o pipefail
touch /var/run/cloud_script_was_here
sed -i"" -E -e "s/.*ssh-/ssh-/" /root/.ssh/authorized_keys
# https://docs.oracle.com/en-us/iaas/Content/Compute/Tasks/gettingmetadata.htm
curl --fail -H Authorization:\ Bearer\ Oracle -s \
    http://169.254.169.254/opc/v2/instance \
    | jq . > /var/run/oci_metadata.json
mkdir -p /usr/local/etc/pkg/repos
sed -E -e s/quarterly/latest/ /etc/pkg/FreeBSD.conf \
    | tee /usr/local/etc/pkg/repos/FreeBSD.conf
pkg upgrade -yr FreeBSD
pkg install -Uyr FreeBSD \
    devel/git@tiny \
    devel/oci-cli \
    sysutils/fd \
    shells/fish \
    sysutils/htop \
    net/mosh \
    editors/neovim \
    net/ngrep \
    devel/ninja \
    textproc/ripgrep \
    net/rsync \
    security/sudo \
    sysutils/tmux
' | tee $USERDATA
    # FreeBSD-14.3-RELEASE-arm64-zfs
    set -l IMAGE_OCID       'ocid1.image.oc1..aaaaaaaakcp6qvubkpqzprnfca6hpgencllptvuu5cw7tr6thnublyj6vcla'
    set -l SUBNET_OCID      'ocid1.subnet.oc1....'
    set -l TENANCY_OCID     'ocid1.tenancy.oc1.....'
    set -l COMPARTMENT_OCID $TENANCY_OCID
    set -l AVAILABILITY_DOMAIN 'hENZ:EU-FRANKFURT-1-AD-3'

    # https://docs.cloud.oracle.com/en-us/iaas/tools/oci-cli/latest/oci_cli_docs/cmdref/compute/instance/launch.html#cmdoption-shape
    set -l SHAPE 'VM.Standard.A1.Flex'
    set -l SHAPE_CONFIG '{"memoryInGBs": 6, "ocpus": 2}'
    set -l TAGS '{"GIT_REPO":"https://git.sr.ht/~dch/src", "GIT_REF":"13.2-oci", "IMG_ARCH":"arm64", "IMG_NAME": "FreeBSD-13.2-RELEASE-20230411-1455-99eb544-amd64-amd64.img"}'
    oci compute instance launch \
        --availability-domain $AVAILABILITY_DOMAIN \
        --compartment-id $COMPARTMENT_OCID \
        --image-id $IMAGE_OCID \
        --subnet-id $SUBNET_OCID \
        --shape $SHAPE \
        --shape-config $SHAPE_CONFIG \
        --boot-volume-size-in-gbs 50 \
        --ssh-authorized-keys-file ~/.ssh/id_ed25519.pub \
        --wait-for-state RUNNING \
        --display-name $argv[1] \
        --hostname-label $argv[1] \
        --freeform-tags $TAGS \
        --user-data-file $USERDATA
    rm -f $USERDATA
end