function jc
    # see https://git.io/JfHOu
    set local
    set MACH (sysctl -n hw.machine)
    set ARCH (sysctl -n hw.machine_arch)
    set DOMAIN skunkwerks.at
    set RELEASE 14.0-RELEASE
    set RELDATE 1400097
    set FLAVOUR $RELEASE-$MACH-$ARCH
    # grab the name
    set JAIL $argv[1]
    # the container
    set TEMPLATE /jails/templates/$FLAVOUR
    set INSTANCE /jails/instances/$FLAVOUR/$JAIL

    # find the zpool for jails and jailed datasets
    set ZPOOL (zfs list -Ho name /jails | cut -f 1 -d /)

    # create a /jailed dataset to contain optional per-jail jailable datasets
    # this can be located on an alternative zpool but must not be mountable
    zfs list -Ho name -d1 |grep /jailed\$ > /dev/null 2>&1 \
        || doas zfs create -o mountpoint=none -o canmount=off $ZPOOL/jailed
    # re-fetch after possible creation
    set JAILED (zfs list -Ho name -d1 | grep /jailed\$)

    # derive a hopefully non-clashing IP address
    set IPA (echo -n $JAIL | sha512 | cut -c 1,2)
    set IPB (echo -n $JAIL | sha512 | cut -c 3,4)
    set IP6 $IPA$IPB
    set IP (printf "%d.%d" 0x$IPA 0x$IPB)
    # get the zt 6plane
    set IFACE (ifconfig | sort -r | /usr/bin/egrep -o '^zt[a-z0-9]+' | head -1)
    set SUBNET (ifconfig $IFACE inet6 | rg -Po 'fc\S+::' | uniq)
    set ALIAS "$IFACE|$SUBNET$IP6"
    # display config and try to start it
    echo name=$JAIL ip=$IP ip6=$IP6 iface=$IFACE subnet=$SUBNET alias=$ALIAS
end