function jz
    # see https://git.io/JfHOu
    set local
    set MACH (sysctl -n hw.machine)
    set ARCH (sysctl -n hw.machine_arch)
    set DOMAIN skunkwerks.at
    set RELEASE 14.2-RELEASE
    set RELDATE 1402000
    set FLAVOUR $RELEASE-$MACH-$ARCH
    # grab the name
    set JAIL $argv[1]
    # the container
    set TEMPLATE /jails/templates/$FLAVOUR
    set INSTANCE /jails/instances/$FLAVOUR/$JAIL

    # find the zpool for jails and jailed datasets
    set ZPOOL (zfs list -Ho name /jails | cut -f 1 -d /)

    # create a /jailed dataset to contain optional per-jail jailable datasets
    # this can be located on an alternative zpool but must not be mountable
    zfs list -Ho name -d1 |grep /jailed\$ > /dev/null 2>&1 \
        || doas zfs create -o mountpoint=none -o canmount=off $ZPOOL/jailed
    # re-fetch after possible creation
    set JAILED (zfs list -Ho name -d1 | grep /jailed\$)

    # create mountpoint if missing
    zfs list -Ho name $ZPOOL/jails > /dev/null 2>&1 \
        || doas zfs create -o mountpoint=/jails -p $ZPOOL/jails

    # clone a template if missing
    test -d $INSTANCE \
        || doas zfs clone $ZPOOL$TEMPLATE@ready $ZPOOL$INSTANCE \
        && doas zfs snapshot $ZPOOL$INSTANCE@ready

    # add a softlink if missing
    test -L /jails/tags/$JAIL || ln -s $INSTANCE /jails/tags/$JAIL

    # derive a hopefully non-clashing IP address
    set IPA (echo -n $JAIL | sha512 | cut -c 1,2)
    set IPB (echo -n $JAIL | sha512 | cut -c 3,4)
    set IP6 $IPA$IPB
    set IP (printf "%d.%d" 0x$IPA 0x$IPB)
    # get the zt 6plane
    set IFACE (ifconfig | sort -r | /usr/bin/egrep -o '^zt[a-z0-9]+' | head -1)
    set SUBNET (ifconfig $IFACE inet6 | rg -Po 'fc\S+::' | uniq)
    set ALIAS "$IFACE|$SUBNET$IP6"
    # display config and try to start it
    echo name=$JAIL ip=$IP ip6=$IP6 iface=$IFACE subnet=$SUBNET alias=$ALIAS
    jls -j $JAIL > /dev/null 2>&1
    if test $status = 0
        doas jexec $JAIL tmux -u new-session -DAs default
    else
        doas jail -vcmr \
        name=$JAIL \
        path=$INSTANCE \
        exec.created="zfs jail $JAIL $JAILED/$JAIL || true" \
        exec.created="test -c $INSTANCE/dev/null || mount -t devfs devfs $INSTANCE/dev" \
        exec.created="test -c $INSTANCE/tmp || mount -t tmpfs tmpfs $INSTANCE/tmp" \
        exec.start="/bin/sh /etc/rc" \
        exec.poststop="umount $INSTANCE/tmp" \
        exec.poststop="umount $INSTANCE/dev" \
        exec.poststop="logger -p info -t jz removed $JAIL" \
        host.domainname=$DOMAIN \
        host.hostid=0 \
        host.hostname=$JAIL.$DOMAIN \
        host.hostuuid=(uuidgen) \
        ip4.addr="lo1|100.64.$IP" \
        ip6.addr="$ALIAS" \
        allow.chflags \
        allow.mount \
        allow.mount.devfs \
        allow.mount.fdescfs \
        allow.mount.nolinprocfs \
        allow.mount.nullfs \
        allow.mount.procfs \
        allow.mount.tmpfs \
        allow.mount.zfs \
        allow.nomlock \
        allow.noquotas \
        allow.noread_msgbuf \
        allow.noset_hostname \
        allow.nosocket_af \
        allow.nosysvipc \
        allow.raw_sockets \
        allow.reserved_ports \
        allow.sysvipc=1 \
        allow.novmm \
        children.max=0 \
        devfs_ruleset=4 \
        enforce_statfs=1 \
        osreldate=$RELDATE \
        osrelease=$RELEASE \
        persist \
        securelevel=2 \
        sysvmsg=disable \
        sysvsem=disable \
        command=/bin/sh -c "env -i TERM=$TERM tmux -u new-session -DAs default"
    end
end