# sideloading with pkgbase

- stash a list of packages
- sync base packages
- sync ports packages

```
# pkg prime-origins | sort | uniq > /etc/packages.lst
# pkg fetch -yr FreeBSD-base -do /var/tmp/base -g FreeBSD-\*
# pkg fetch -yr FreeBSD -do /var/tmp/pkg $(grep -v \# /etc/packages.lst)
```

- make a `pkg-base.conf` and a `pkg.conf` to use from these downloads

```
# /usr/local/etc/pkg/repos/base.conf
base: {
  url: "file:///var/tmp/base/${ABI}/latest/",
  mirror_type: none,
  enabled: yes
}
```

```
# /usr/local/etc/pkg/repos/pkg.conf
pkg: {
  url: "file:///var/tmp/pkg/",
  mirror_type: none,
  enabled: yes
}
```

- create an empty BE

```
# zfs create -o canmount=noauto -o mountpoint=/ zroot/ROOT/fifteen
# bectl mount fifteen /mnt
# mkdir -p /mnt/tmp /mnt/dev /mnt/var/cache
# mount -t devfs devfs /mnt/dev
# mount -t tmpfs tmpfs /mnt/tmp
# mount -t tmpfs tmpfs /mnt/var/cache
```

- install base system again

```
# pkg -o IGNORE_OSVERSION=yes -o ABI=FreeBSD:15:amd64 --rootdir /mnt install -r base -g FreeBSD-\*
```

- fix up loader.*

```
# cp -av /boot/loader.conf /mnt/boot/
# cp -av /mnt/boot/loader.efi /boot/efi/EFI/Boot/bootx64.efi
```

- and etc

```
# cd /etc
# git init . && git add . && git commit -am sideloading
# cd /mnt
# mv /mnt/etc /mnt/etc.dist
# cp -av /etc /mnt/
# cp -av /mnt/etc.dist//mnt/
# cd /mnt/etc
### repeat until you're happy
# git diff ...
# git restore ...
# git commit ...
```

- install packages from cache

```
pkg -o IGNORE_OSVERSION=yes -o ABI=FreeBSD:15:amd64 --rootdir /mnt install $(grep -v \# /etc/packages.lst)
```

Repeat the `/etc` git dance with `/usr/local/etc/` again

reboot
