#!/bin/sh -eu
export __MAKE_CONF=/dev/null

umask 0022
cd /usr/src
COMMIT=g$(git rev-parse --verify --short=7 HEAD)
NCPU=3.0
NOW=$(date -u +%Y%m%d-%H%M)
QUIET=' -s'
RELEASE=/usr/obj/usr/src/arm64.aarch64/release
REVISION=$(sh ./sys/conf/newvers.sh -V REVISION | egrep -o '1[0-9]+')

chflags -R noschg  ${RELEASE} || /usr/bin/true
chown -R dch:wheel ${RELEASE} || /usr/bin/true
rm -rf ${RELEASE}
git reset --hard
git clean -fdx

doas zfs snapshot \
  -r zroot/usr/src@${NOW}:bebuild-${COMMIT} \
  || /usr/bin/true

time make TARGET_ARCH=aarch64 TARGET=arm64 -j${NCPU} buildworld ${QUIET}
echo DONE BW
date -u +%Y%m%d-%H%M

time make TARGET_ARCH=aarch64 TARGET=arm64 -j${NCPU} buildkernel ${QUIET}
echo DONE BK
date -u +%Y%m%d-%H%M

PACKAGER="time make TARGET_ARCH=aarch64 TARGET=arm64 -j${NCPU}"
if [ -L /var/www/pkgbase/FreeBSD:${REVISION}:aarch64/latest ]; then
    ${PACKAGER} update-packages ${QUIET}
else
    ${PACKAGER} packages ${QUIET}
fi

echo DONE PKG
date -u +%Y%m%d-%H%M

doas ln -sf /var/www/pkgbase /usr/obj/usr/src
(cd release && \
	time make TARGET_ARCH=aarch64 TARGET=arm64 WITH_OCIIMAGES=yes ${QUIET} oci-release)
echo DONE OCI
date -u +%Y%m%d-%H%M

. /usr/local/etc/poudriere.d/hooks/config
/usr/local/bin/s5cmd \
	--endpoint-url ${S3_ENDPOINT_URL} \
	--credentials-file ${S3_CREDENTIALS_FILE} \
	--profile ${S3_PROFILE} \
	sync --delete /var/www/pkgbase/FreeBSD:${REVISION}:aarch64/latest/ \
	s3://pkg/base/FreeBSD:${REVISION}:aarch64/

date -u +%Y%m%d-%H%M
curl -d arm64 https://ntfy.sh/skunkwerks
date -u +%Y%m%d-%H%M
echo DONE ALL | wall
