#!/bin/sh
#
# Copyright (c) 2025 Dave Cottlehuber <dch@FreeBSD.org>

# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

# /usr/local/etc/poudriere.d/hooks/pkgrepo.sh
# PACKAGES PKG_REPO_SIGNING_KEY PKG_REPO_FROM_HOST PKG_REPO_META_FILE

[ -f "${POUDRIERED}/hooks/config" ] && . "${POUDRIERED}/hooks/config"

fetch_custom_packages() {
        [ "${FETCH_PKG_FROM_S3:-0}" -eq 1 ] || return 0

        arch=$(pkg info -f -F ${PACKAGES}/Latest/pkg.pkg |
            awk '$1 == "Architecture" {print $3}')

        /usr/local/bin/s5cmd \
                --endpoint-url ${S3_ENDPOINT_URL} \
                --credentials-file ${S3_CREDENTIALS_FILE} \
                --profile ${S3_PROFILE} \
                sync s3://pkg/indie/${arch}/\*.pkg ${PACKAGES}/All/
        # ignore errors if there are no packages because indie:15:amd64/ "dir" is not present
        return 0
}

status="$1"

shift

case ${status} in
        "sign")
                fetch_custom_packages "$@"
                ;;
esac
exit 0