#!/bin/sh
# /usr/local/etc/poudriere.d/hooks/bulk.sh

[ -f "${POUDRIERED}/hooks/config" ] && . "${POUDRIERED}/hooks/config"

bulk_sync() {

        local arch=$(pkg info -f -F ${PACKAGES}/Latest/pkg.??? |
            awk '$1 == "Architecture" {print $3}')

        curl ${NTFY_URL} -d "$(hostname -s) ${arch} built $1 failed $2 ignored $3 skipped $4"

        [ "${SHOULD_SYNC_TO_S3:-0}" -eq 1 ] || return 0

        touch ${PACKAGES}/.commitid
        (cd /usr/ports && git rev-parse HEAD > ${PACKAGES}/.commitid)
        (cd ${PACKAGES} && s5cmd \
                --endpoint-url ${S3_ENDPOINT_URL} \
                --credentials-file ${S3_CREDENTIALS_FILE} \
                --profile ${S3_PROFILE} \
                sync --delete \
                --include 'All/*.pkg' \
                --include 'All/*.txz' \
                --include 'Latest/pkg.*' \
                --include .buildname \
                --include .commitid \
                --include .jailversion \
                --include data.pkg \
                --include meta.conf \
                --include packagesite.pkg \
                --no-follow-symlinks \
                . \
                s3://pkg/${arch}/ )
        return 0
}

status="$1"
shift

case ${status} in
        "done")
                test $2 -le 0 && bulk_sync "$@"
                ;;
esac
exit 0