#!/bin/sh
# /usr/local/etc/poudriere.d/hooks/pkgrepo.sh
# PACKAGES PKG_REPO_SIGNING_KEY PKG_REPO_FROM_HOST PKG_REPO_META_FILE

[ -f "${POUDRIERED}/hooks/config" ] && . "${POUDRIERED}/hooks/config"

fetch_custom_packages() {
        [ "${FETCH_PKG_FROM_S3:-0}" -eq 1 ] || return 0

        arch=$(pkg info -f -F ${PACKAGES}/Latest/pkg.pkg |
            awk '$1 == "Architecture" {print $3}')

        /usr/local/bin/s5cmd \
                --endpoint-url ${S3_ENDPOINT_URL} \
                --credentials-file ${S3_CREDENTIALS_FILE} \
                --profile ${S3_PROFILE} \
                sync s3://pkg/indie/${arch}/\*.pkg ${PACKAGES}/All/
        # ignore errors if there are no packages because indie:15:amd64/ "dir" is not present
        return 0
}

status="$1"

shift

case ${status} in
        "sign")
                fetch_custom_packages "$@"
                ;;
esac
exit 0