# Upgrading a 15.0-RELEASE base package install to 16-CURRENT

I know, 15.0-RELEASE has been out now for over a month, and I'm easily bored. Obviously, it's time to switch back to running 16-CURRENT with whatever random patches I am working on atm.

This is the general procedure:

- create an old environment
- create a new boot environment
- mount it 
- finagle package signatures
- do the upgrade of the base system packages
- do the upgrade of ports tree packages
- update the (UEFI) boot loader for 16
- reboot & profit

```
# bectl create fifteen
# bectl create current
# bectl activate current
# bectl mount current /mnt
# cd /mnt
# mount -t devfs devfs dev
# mount -t tmpfs tmpfs tmp
# chroot .
```

We're now in the chroot!

The `fingerprints` setting used in `/etc/pkg/FreeBSD.conf` are
different between what's required for a
[release](https://cgit.freebsd.org/src/tree/usr.sbin/pkg), and
[current](https://cgit.freebsd.org/src/plain/usr.sbin/pkg/FreeBSD.conf.latest).

We need to fetch what would be installed during a 16-CURRENT
update, beforehand, or the signatures don't work.

```
# fetch -o /etc/pkg/FreeBSD.conf https://cgit.freebsd.org/src/plain/usr.sbin/pkg/FreeBSD.conf.latest
# rm -f /usr/local/etc/pkg/repos/*
# echo 'FreeBSD-base:  { enabled: yes }' | tee /usr/local/etc/pkg/repos/FreeBSD.conf
# pkg-static -o IGNORE_OSVERSION=yes -o ABI=FreeBSD:16:amd64 update
# pkg-static -o IGNORE_OSVERSION=yes -o ABI=FreeBSD:16:amd64 upgrade -r FreeBSD-base
# pkg-static -o IGNORE_OSVERSION=yes -o ABI=FreeBSD:16:amd64 upgrade -r FreeBSD-ports
# exit
```

Now let's do the boot loader. The 16-CURRENT boot loader should be capable of loading 15.0-RELEASE without issue, but I use [rEFInd](https://www.rodsbooks.com/refind/) a custom EFI boot loader that allows me to choose between different loaders on startup. You'll likely need to use [efibootmgr(8)](https://man.freebsd.org/efibootmgr) to handle this.

```
# cp -av /mnt/boot/loader.efi /boot/efi/EFI/FreeBSD/current.efi
```

Let's reboot!