# Upgrading a 15.0-RELEASE base package install to 16-CURRENT

I know, 15.0-RELEASE has been out now for over a month,
and we're already bored.

It's time to switch back to running 16-CURRENT with
whatever random patches I am working on atm.

- create an old environment
- create a new boot environment
- mount it 
- finagle the pkg settings
- do the upgrade

```
# bectl create fifteen
# bectl create current
# bectl activate current
# bectl mount current /mnt
# cd /mnt
# mount -t devfs devfs dev
# mount -t tmpfs tmpfs tmp
# chroot .
```

We're now in the chroot!

The `fingerprints` setting used in `/etc/pkg/FreeBSD.conf` are
different between what's required for a
[release](https://cgit.freebsd.org/src/tree/usr.sbin/pkg), and
[current](https://cgit.freebsd.org/src/plain/usr.sbin/pkg/FreeBSD.conf.latest).

We need to fetch what would be installed during a 16-CURRENT
update, beforehand, or the signatures don't work.

```
# fetch -o /etc/pkg/FreeBSD.conf https://cgit.freebsd.org/src/plain/usr.sbin/pkg/FreeBSD.conf.latest
# rm -f /usr/local/etc/pkg/repos/*
# echo 'FreeBSD-base:  { enabled: yes }' | tee /usr/local/etc/pkg/repos/FreeBSD.conf
# pkg-static -o IGNORE_OSVERSION=yes -o ABI=FreeBSD:16:amd64 update
# pkg-static -o IGNORE_OSVERSION=yes -o ABI=FreeBSD:16:amd64 upgrade -r FreeBSD-base
# pkg-static -o IGNORE_OSVERSION=yes -o ABI=FreeBSD:16:amd64 upgrade -r FreeBSD-ports
# exit
```

